void Main()
{
  AddFilesToFolder();

  var zipPath = Path.Combine (DirectoryToZip, "..", "archive.zip");
  ZipFile.CreateFromDirectory (DirectoryToZip, zipPath);

  Directory.CreateDirectory (DirectoryToExtractTo);
  ZipFile.ExtractToDirectory (zipPath, DirectoryToExtractTo);

  Directory.EnumerateFiles (DirectoryToExtractTo).Dump ("Extracted files");
}

string DirectoryToZip =>
  RuntimeInformation.IsOSPlatform (OSPlatform.Windows)
    ? @".\MyFolder"
    : "./MyFolder";

string DirectoryToExtractTo =>
  RuntimeInformation.IsOSPlatform (OSPlatform.Windows)
    ? @".\Extracted"
    : "./Extracted";

void AddFilesToFolder()
{
  Directory.CreateDirectory (DirectoryToZip);
  foreach (var c in new char[] { 'A', 'B', 'C' })
    File.WriteAllText (Path.Combine (DirectoryToZip, $"{c}.txt"), $"This is {c}");
}